//******************************************************************************
//
//	File:		InstantiateBColorControl.h
//
//	Description:	Unarchiving a BColorControl instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//	This is only a minimum version.
//
//******************************************************************************

#include "ColorControl.h"
#include <string.h>

#pragma export on
BColorControl* InstantiateBColorControl(BMessage *message);
#pragma export off

BColorControl* InstantiateBColorControl(BMessage *message)
{
	BColorControl			*instance;
	BPoint					start;
	color_control_layout	layout;
	long 					cell_size;
	bool 					use_offscreen = FALSE;
	long					follow;

	
	// Default values
	
	start.x = 10;
	start.y = 10;
	layout = B_CELLS_32x8;
	cell_size = 6;
	
	// Decode instance values
	
	if (message->HasPoint("Origin")) {
		start = message->FindPoint("Origin");
	}	

	if (message->HasLong("Follow Mode")) {
		follow = message->FindLong("Follow Mode");
	}	

	instance = new BColorControl(	start,
									layout,
									cell_size,
									"ColorControl",
									NULL,
									use_offscreen);
										
	return instance;
}